/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.fsp.FSPCMCustomHWSMessage;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspSimpleCmds;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class FspAuthInfo {
    private UnsignedInt16 _cmdRetCode = null;
    private UnsignedInt8 _passwordStatusFlags = null;
    private static final String PLATFORM_PASSWORD = "PLATFORM_PASSWORD";
    private static final String SET_PASSWORDS = "SET_PASSWORDS";

    private void debug(String string) {
        System.out.println("| FspAuthInfo." + string);
    }

    public void platformPassword(FSPCmdMgr fSPCmdMgr, String string) throws PIHscCmdMgrException {
        this.debug("Entering platformPassword()");
        this._cmdRetCode = null;
        int n = 30000;
        HardwareServerMessage hardwareServerMessage = null;
        try {
            this.debug("Building platformPassword cmd...");
            int n2 = string.length();
            byte[] byArray = new byte[2 + n2];
            int n3 = 0;
            HardwareServerMessage.shortToBytes((short)string.length(), byArray, n3);
            System.arraycopy(string.getBytes(), 0, byArray, n3 += 2, n2);
            n3 += n2;
            if (fSPCmdMgr.isFsp()) {
                this.debug("target is a FSP");
                hardwareServerMessage = fSPCmdMgr.doHardwareServerCmd(PLATFORM_PASSWORD, new FSPCMCustomHWSMessage(80, 108), byArray, n);
            } else {
                this.debug("target is a BPA");
                hardwareServerMessage = fSPCmdMgr.doHardwareServerCmd(PLATFORM_PASSWORD, new FSPCMCustomHWSMessage(80, 127), byArray, n);
            }
            int n4 = hardwareServerMessage.getMinorOpCode();
            System.out.println("platformPassword::minor = " + n4);
            this._cmdRetCode = n4 == 109 || n4 == 128 ? new UnsignedInt16(0) : (n4 == 110 || n4 == 129 ? new UnsignedInt16(1) : new UnsignedInt16(38));
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
            this._cmdRetCode = new UnsignedInt16(pIHscCmdMgrException.getStatus());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.debug("Exiting platformPassword");
    }

    public void setPasswords(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8, String string, String string2) throws PIHscCmdMgrException {
        this.debug("Entering setPasswords()");
        this._cmdRetCode = this._cmdRetCode = new UnsignedInt16(1);
        if ("$$Not$$Set$$".equals(string)) {
            string = "";
            this.debug("Resetting currentPassword");
        } else {
            this.debug("NOT resetting currentPassword to");
        }
        String[] stringArray = new String[]{"" + unsignedInt8.byteValue(), ByteUtilities.toHexString(FspSimpleCmds.javaToFSPString(string)), ByteUtilities.toHexString(FspSimpleCmds.javaToFSPString(string2))};
        try {
            this.debug("Sending SET_PASSWORDS cmd...");
            Hashtable hashtable = fSPCmdMgr.doAuthCommand(SET_PASSWORDS, stringArray, 0);
            this.debug("SET_PASSWORDS resp = " + hashtable);
            this._cmdRetCode = new UnsignedInt16(0);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
            this.debug("SET_PASSWORDS status = " + pIHscCmdMgrException.getStatus());
            this._cmdRetCode = new UnsignedInt16(pIHscCmdMgrException.getStatus());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this._cmdRetCode = new UnsignedInt16(1);
        }
        this.debug("Exiting setPasswords()");
    }

    public UnsignedInt16 getRetCode() {
        return this._cmdRetCode;
    }

    public UnsignedInt8 getPasswordStatusFlags() {
        return this._passwordStatusFlags;
    }
}

